// Copyright (C) 2010-2011 Tencent Inc. All Rights Reserved.
// 版权所有 (C) 2010-2011 腾讯公司，保留所有权利。

/**
 * @fileOverview Tooltip 页面显示
 * @author luangong@tencent.com
 * @version 1.0
 */
var tooltip = {};

var Cube = {};
Cube.String =  {};
Cube.String.htmlEncode = (function() {
	var entities = {
		'&': '&amp;',
		'>': '&gt;',
		'<': '&lt;',
		'"': '&quot;',
		' ': '&nbsp;'
	}, keys = [], p, regex;

	for (p in entities) {
		keys.push(p);
	}

	regex = new RegExp('(' + keys.join('|') + ')', 'g');

	return function(value) {
		return (!value) ? value : String(value).replace(regex, function(match, capture) {
			return entities[capture];
		});
	};
})();

/**
 * Tooltip 页面的初始化函数
 */
tooltip.init = function() {
    document.onselectstart = document.ondragstart = function() {
        return false;
    };

    var pid = tooltip.getPid();
    var id = tooltip.getId();

    qqbrowser.tooltip.init(pid, id, function(returnData) {
        console.log("tooltip: " + returnData);
        try {
            if (returnData == '[]') {
                return;
            }

            var textObject = JSON.parse(returnData)[0];

            if (textObject.hasOwnProperty('title')) {
                document.getElementById('title').innerHTML = Cube.String.htmlEncode(unescape(textObject['title']));
            }

            if (textObject.hasOwnProperty('content')) {
                document.getElementById('content').innerHTML = unescape(textObject['content']);
            }

            if (textObject.padding) {
                document.getElementById('content').style.padding = textObject.padding;
            }

            if (textObject.hasOwnProperty('url')) {
                document.getElementById('url').innerText = unescape(textObject['url']);
            }

            if (textObject.hasOwnProperty('type')) {
                if (textObject.type == 'l') { // 如果传过来 l 参数，表示应该用最大化布局
                    document.getElementById('tooltip-box').className = 'tooltip-box max'; 
                }
            }

            var tooltipBox = document.getElementById('tooltip-box');
            qqbrowser.tooltip.show(pid, id, tooltipBox.offsetWidth, tooltipBox.offsetHeight);

        } catch (err) {

            console.error(err.name + ': ' + err.message + '\n' + returnData);
        }
    });
};

/**
 * 获取 PID
 * @returns {Number} PID
 */
tooltip.getPid = function() {
    return parseInt(getArgs().pid);
};

/**
 * 获取 ID
 * @returns {Number} ID
 */
tooltip.getId = function() {
    return parseInt(getArgs().id);
};

/**
 * 获取 URL 里的 query 参数
 * @returns {Object} 代表 name/value 对的对象。
 */
function getArgs() {
    var args = {};
    var query = location.search.substring(1);
    var pairs = query.split('&');

    for (var i = 0; i < pairs.length; i++) {
        var pos = pairs[i].indexOf('=');
        if (pos == -1) continue;
        var argname = pairs[i].substring(0, pos);
        var value = pairs[i].substring(pos + 1);
        value = decodeURIComponent(value);
        args[argname] = value;
    }
    return args;
}

window.onload = tooltip.init();
